/**
 * Create a modal.
 *
 * @module     core/modal_factory
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/modal_factory",["jquery","core/modal_events","core/modal_registry","core/modal","core/modal_save_cancel","core/modal_cancel","core/local/modal/alert","core/templates","core/notification","core/custom_interaction_events","core/pending"],(function($,ModalEvents,ModalRegistry,Modal,ModalSaveCancel,ModalCancel,ModalAlert,Templates,Notification,CustomEvents,Pending){var TEMPLATES_DEFAULT="core/modal",TEMPLATES_SAVE_CANCEL="core/modal_save_cancel",TEMPLATES_CANCEL="core/modal_cancel",TEMPLATES_ALERT="core/local/modal/alert",TYPES={DEFAULT:"DEFAULT",SAVE_CANCEL:"SAVE_CANCEL",CANCEL:"CANCEL",ALERT:"ALERT"};ModalRegistry.register(TYPES.DEFAULT,Modal,TEMPLATES_DEFAULT),ModalRegistry.register(TYPES.SAVE_CANCEL,ModalSaveCancel,TEMPLATES_SAVE_CANCEL),ModalRegistry.register(TYPES.CANCEL,ModalCancel,TEMPLATES_CANCEL),ModalRegistry.register(TYPES.ALERT,ModalAlert,TEMPLATES_ALERT);var createFromType=function(registryConf,templateContext){var templateName=registryConf.template,modalPromise=Templates.render(templateName,templateContext).then((function(html){var modalElement=$(html);return function(registryConf,modalElement){return modalElement=$(modalElement),new(0,registryConf.module)(modalElement)}(registryConf,modalElement)})).fail(Notification.exception);return modalPromise};return{create:function(modalConfig,triggerElement){var registryConf,type=modalConfig.type||TYPES.DEFAULT,isLarge=!!modalConfig.large,isScrollable=!modalConfig.hasOwnProperty("scrollable")||modalConfig.scrollable,templateContext={};(registryConf=ModalRegistry.get(type))||Notification.exception({message:"Unable to find modal of type: "+type}),void 0!==modalConfig.templateContext&&(templateContext=modalConfig.templateContext);var pendingModalPromise=new Pending("core/modal_factory:create"),modalPromise=createFromType(registryConf,templateContext).then((function(modal){return void 0!==modalConfig.title&&modal.setTitle(modalConfig.title),void 0!==modalConfig.body&&modal.setBody(modalConfig.body),void 0!==modalConfig.footer&&modal.setFooter(modalConfig.footer),modalConfig.buttons&&Object.entries(modalConfig.buttons).forEach((function(_ref){let[key,value]=_ref;modal.setButtonText(key,value)})),isLarge&&modal.setLarge(),void 0!==modalConfig.removeOnClose&&modal.setRemoveOnClose(modalConfig.removeOnClose),modal.setScrollable(isScrollable),pendingModalPromise.resolve(),modal}));return void 0!==triggerElement&&function(modalPromise,triggerElement,modalConfig){var actualTriggerElement=null,hasPreShowCallback="function"==typeof modalConfig.preShowCallback,triggeredCallback=function(e,data){var pendingPromise=new Pending("core/modal_factory:setUpTrigger:triggeredCallback");actualTriggerElement=$(e.currentTarget),modalPromise.then((function(modal){return hasPreShowCallback&&modalConfig.preShowCallback(actualTriggerElement,modal),modal.show(),modal})).then(pendingPromise.resolve),data.originalEvent.preventDefault()};if(Array.isArray(triggerElement)){var selector=triggerElement[1];triggerElement=triggerElement[0],CustomEvents.define(triggerElement,[CustomEvents.events.activate]),triggerElement.on(CustomEvents.events.activate,selector,triggeredCallback)}else CustomEvents.define(triggerElement,[CustomEvents.events.activate]),triggerElement.on(CustomEvents.events.activate,triggeredCallback);modalPromise.then((function(modal){return modal.getRoot().on(ModalEvents.hidden,(function(){null!==actualTriggerElement&&actualTriggerElement.focus()})),modal}))}(modalPromise,triggerElement,modalConfig),modalPromise},types:TYPES}}));

//# sourceMappingURL=modal_factory.min.js.map